;; This example shows how to dump the lower ROM
;; of an Amstrad CPC or KC Compact computer.
;;
;; When active, the lower ROM is readable in the range &0000-&3fff.
;; The lower ROM contains the operating system and firmware.
;;
;; This source is released under the GNU Public License V2.

;; firmware function to activate the lower rom
.kl_l_rom_enable	equ &b906
;; firmware function to restore the rom state
.kl_rom_restore		equ &b90c

;;----------------------------------------------------------

;; When activated, the lower rom will be readable from &0000-&3fff.
;; The program will not function if it is in this range.
org &4000

;;-----------------------------------------
;; enable the lower (operating system) rom
;; and store the previous state
call kl_l_rom_enable
ld (rom_previous_state),a

;;-----------------------------------------
;; copy rom data to store
ld hl,&0000				;; source
ld de,rom_data			;; dest
ld bc,&4000				;; length
ldir

;;-----------------------------------------
;; restore the previous state
ld a,(rom_previous_state)
call kl_rom_restore
ret

;;-----------------------------------------

;; stores the previous state of the rom configuration
.rom_previous_state defb 0

;; a buffer to store the 16k of rom data
.rom_data equ $+1


